#version 330

#if _DIFFUSE_MAP
uniform sampler2D diffuseMap;
#endif
#if _ALPHA_MAP
uniform sampler2D alphaMap;
#endif
#if _DIFFUSE_ARRAY
uniform sampler2DArray diffuseArray;
#endif

void main()
{
#if _DIFFUSE_MAP
	vec2 dx = dFdx(depthUv.yz);
	vec2 dy = dFdy(depthUv.yz);
	if(textureGrad(diffuseMap, depthUv.yz, dx, dy).a < 0.5) discard;
#endif
#if _ALPHA_MAP
	vec2 dx = dFdx(depthUv.yz);
	vec2 dy = dFdy(depthUv.yz);
	if(textureGrad(alphaMap, depthUv.yz, dx, dy).r < 0.5) discard;
#endif
#if _DIFFUSE_ARRAY
	vec2 dx = dFdx(depthUv.yz);
	vec2 dy = dFdy(depthUv.yz);
	if(textureGrad(diffuseArray, depthUv.yzw, dx, dy).a < 0.5) discard;
#endif
}
